DROP PROCEDURE IF EXISTS sp_insertUpdateNotaSalidaFromDocumentoVenta;

delimiter $
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateNotaSalidaFromDocumentoVenta`(
	IN p_idDocumentoVenta INT,  
    IN p_usuario VARCHAR(50))
BEGIN 
    DECLARE v_cor char(8);
    DECLARE v_id int;
    
		SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM NOTA_ALMACEN WHERE correlativo is not null 
								ORDER BY correlativo desc limit 1), 0);
        
		SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
							WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
					END);
        
            
		INSERT INTO NOTA_ALMACEN (idAlmacen, idDocumentoVenta, correlativo, idDestino, tipoDocumento, serieDocumento, numeroDocumento,
					tipoOperacion, idTipoDocumento, subTotal, igv, igv2, total, fechaEmision, fechaContable, observaciones, 
                    tipoNota, estado,
					registro_fecha_add, registro_user_add, registro_pc_add, activo)
		SELECT 1, id, @v_cor, 5, M.abrev, DV.serie, DV.numero,
			'01', '04', DV.monto_subtotal, DV.igv, DV.monto_igv_total, DV.monto_total, now(), now(), '', 
            'S', 'C',
            now(), p_usuario, '-', 1
		FROM DOCUMENTO_VENTA DV
        INNER JOIN MULTITABLA M ON M.valor = DV.idTipoDocumento and M.dep_id = 15
        WHERE DV.id = p_idDocumentoVenta;
        
        
        
        SET @v_id = LAST_INSERT_ID();
        
        INSERT INTO DETALLE_NOTA_ALMACEN (					
			idNotaAlmacen, idProducto, nombreProducto, idPresentacion, nombrePresentacion,
			valorPresentacion, precioPresentacion, 
			valorUnitario, precioUnitario, cantidad, 
			valorVenta, monto, 
			cantidadTotal, cantidadUsada, cantidadSaldo, 
			idUnidadMedida, unidadMedida, estado, 
			registro_fecha_add, registro_user_add, registro_pc_add, activo)
		SELECT LAST_INSERT_ID(), P.idProducto, P.nombre, NULL, NULL,
			0.00, 0.00,
			DDV.valor_unitario * DV.tasa_cambio, 
			DDV.precio_unitario * DV.tasa_cambio,
            DDV.cantidad, 
			DDV.valor_total * DV.tasa_cambio, DDV.precio_total * DV.tasa_cambio,
			DDV.cantidad, 0.00, DDV.cantidad,
            M.abrev, M.descripcion, 'C',
            now(), 'ADMIN', '-', 1
		FROM DETALLE_DOCUMENTO_VENTA DDV
		INNER JOIN DOCUMENTO_VENTA DV ON DV.id = DDV.documento_venta_id
        INNER JOIN PRODUCTO P ON P.idProducto = DDV.producto_id
        INNER JOIN MULTITABLA M ON M.abrev = P.unidad_medida
		WHERE DDV.documento_venta_id = p_idDocumentoVenta AND DDV.activo = 1;
        
        
        UPDATE PRODUCTO P, (
			SELECT DDV.producto_id as idProducto, SUM(DDV.cantidad) as cantidad
			FROM DETALLE_DOCUMENTO_VENTA DDV
			INNER JOIN DOCUMENTO_VENTA DV ON DV.id = DDV.documento_venta_id
			INNER JOIN PRODUCTO P ON P.idProducto = DDV.producto_id
			INNER JOIN MULTITABLA M ON M.abrev = P.unidad_medida
			WHERE DDV.documento_venta_id = p_idDocumentoVenta AND DDV.activo = 1
            GROUP BY DDV.producto_id
		) DNA
		SET 
			P.StockActual = P.StockActual - DNA.cantidad
		WHERE P.idProducto = DNA.idProducto;
        
		SELECT 1 as tipoRespuesta, @v_id as idNotaAlmacen, 
			concat('Se registró correctamente la Nota de Almacen NA-', @v_cor) as 'respuesta';
	
END
$